
 #ifndef TESTCLASS_H
 #define TESTCLASS_H
 #include "genericAsyncTask.h"
 class TestClass : public GenericAsyncTask
 {
 private:
    int p;
 
 public:
    TestClass() : GenericAsyncTask() {}
    ~TestClass(){}
    ALLOC_DELETED_CHAIN(TestClass);
 };

 void testFunction( const Event * e )
 {
    printf("testFunction\n");
    //printf("Number of Parameters: %1d\n", e->get_num_parameters());
    nassertv( e->get_num_parameters() == 1 );
    TypedWritableReferenceCount * value( e->get_parameter(0).get_ptr() ); // pointer to CollisionEntry
    PT(CollisionEntry) entry = DCAST(CollisionEntry, value); 
    nassertv( entry != NULL );
    
    cerr << "Collision from " << entry->get_from_node_path().get_tag( "Object Key" )
         << " into " << entry->get_into_node_path().get_tag( "Object Key" ) << "\n";
    cerr << "Collision from " << entry->get_from_node_path().get_key() 
         << " into " << entry->get_into_node_path().get_key() << "\n";
 }
 #endif // TESTCLASS_H